
!define PRODUCT_NAME "UniMate"
!define PRODUCT_VERSION "1.0.3"
!define FILE_DESCRIPTION "UniMate PKI package"
!define ORIGINAL_FILE_NAME "UniMate PKI package"
!define PRODUCT_PUBLISHER "SecuTech Solution Inc."
!define CmpName "SecuTech Solution Inc."
!define PRODUCT_WEB_SITE "http://www.esecutech.com"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}\PKI package"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor /SOLID lzma
SetCompressorDictSize 32

; ------ MUI Interface (Ver 1.67 upper) ------
!include "MUI.nsh"
!include "x64.nsh"
!include "LogicLib.nsh"

; MUI pri-define const
!define MUI_ABORTWARNING
!define MUI_ICON "..\Package-Files\logo.ico"

; WELCOME PAGE
!insertmacro MUI_PAGE_WELCOME
; INSTALLING PAGE
!insertmacro MUI_PAGE_INSTFILES
; FINISH PAGE
!insertmacro MUI_PAGE_FINISH

; UNINS PAGE
!insertmacro MUI_UNPAGE_INSTFILES

; LANGUAGE SETTING
!insertmacro MUI_LANGUAGE "English"

!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS
; ------ MUI interface finished ------

Name "${ORIGINAL_FILE_NAME} ${PRODUCT_VERSION}"
OutFile "UniMate PKI package.exe"
InstallDirRegKey HKLM "${PRODUCT_UNINST_KEY}" "UninstallString"
ShowInstDetails show
RequestExecutionLevel admin

VIProductVersion 1.0.3.0115
VIAddVersionKey FileDescription "${FILE_DESCRIPTION}" 
VIAddVersionKey FileVersion "${PRODUCT_VERSION}" 
VIAddVersionKey ProductName "${PRODUCT_NAME}"
VIAddVersionKey ProductVersion "${PRODUCT_VERSION}" 
VIAddVersionKey Comments "${Name} ${Ver}"
VIAddVersionKey CompanyName "${CmpName}"
VIAddVersionKey LegalCopyright "Copyright (C) ${PRODUCT_PUBLISHER}"
VIAddVersionKey InternalName "${Name}"
VIAddVersionKey LegalTrademarks "${PRODUCT_PUBLISHER}" 
VIAddVersionKey OriginalFilename "${ORIGINAL_FILE_NAME}"
VIAddVersionKey PrivateBuild "XX" 
VIAddVersionKey SpecialBuild "XX" 

;Function .onInit
;FindProcDLL::FindProc "TokenMonitor.exe"
;   Pop $R0
;   IntCmp $R0 1 0 no_run
;   MessageBox MB_ICONSTOP "The installer detects TokenMonitor is running, please close the application and try again."
;   Quit
;   no_run:
;   FindProcDLL::FindProc "Console.exe"
;      Pop $R0
;      IntCmp $R0 1 0 no_run1
;      MessageBox MB_ICONSTOP "The installer detects Console is running, please close the application and try again."
;      Quit
;      no_run1:
;      FindProcDLL::FindProc "Partition.exe"
;         Pop $R0
;         IntCmp $R0 1 0 no_run2
;         MessageBox MB_ICONSTOP "The installer detects Partition.exe is running, please close the application and try again."
;         Quit
;         no_run2:
;FunctionEnd


Section "MainSection" SEC01

${If} ${RunningX64}
System::Call "Kernel32::Wow64EnableWow64FsRedirection(i 0)"
  SetOverwrite ifnewer
	CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}\PKI package"
  SetOutPath "$SYSDIR"
	File "..\Package-Files\x64\EN_certDate_x64.reg"
  ExecWait "regedit.exe /s EN_certDate_x64.reg"
  Delete "EN_certDate_x64.reg"
  File "..\Package-Files\x64\UniMateP11.dll"
  File "..\Package-Files\x64\utcspsh.sig"
  File "..\Package-Files\x64\utcspsh.dll"
  File "..\Package-Files\x64\utcsp.dll"
  ExecWait '$SYSDIR\regsvr32 /s "$SYSDIR\utcsp.dll"'
  
System::Call "Kernel32::Wow64EnableWow64FsRedirection(i 1)"
  SetOutPath "$SYSDIR"
  File "..\Package-Files\x86\UniMateP11.dll"
  File "..\Package-Files\x86\utcspsh.sig"
  File "..\Package-Files\x86\utcspsh.dll"
  File "..\Package-Files\x86\utcsp.dll"
  File "..\Package-Files\x86\EN_certDate_x86.reg"
  ExecWait "regedit.exe /s EN_certDate_x86.reg"
  Delete "EN_certDate_x86.reg"
  ExecWait '$SYSDIR\regsvr32 /s "$SYSDIR\utcsp.dll"'
  
${Else}
  SetOverwrite ifnewer
  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}\PKI package"
  SetOutPath "$SYSDIR"
  File "..\Package-Files\x86\EN_certDate_x86.reg"
  ExecWait "regedit.exe /s EN_certDate_x86.reg"
  Delete "EN_certDate_x86.reg"
  File "..\Package-Files\x86\UniMateP11.dll"
  File "..\Package-Files\x86\utcspsh.sig"
  File "..\Package-Files\x86\utcspsh.dll"
  File "..\Package-Files\x86\utcsp.dll"
	ExecWait '$SYSDIR\regsvr32 /s "$SYSDIR\utcsp.dll"'
${EndIf}
SectionEnd

Section -AdditionalIcons
  SetOutPath $SMPROGRAMS
  WriteIniStr "$SMPROGRAMS\${PRODUCT_NAME}\PKI package\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
SectionEnd

Section -Post
  WriteUninstaller "$SMPROGRAMS\${PRODUCT_NAME}\PKI package\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$SMPROGRAMS\${PRODUCT_NAME}\PKI package\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

/******************************
 *  uninstall   *
 ******************************/


Section Uninstall

${If} ${RunningX64}
;${EnableX64FSRedirection}

 System::Call "Kernel32::Wow64EnableWow64FsRedirection(i 0)"
	ExecWait '$SYSDIR\regsvr32 /s /u "$SYSDIR\utcsp.dll"'
  Delete "$SYSDIR\utcsp.dll"
  Delete "$SYSDIR\utcspsh.dll"
  Delete "$SYSDIR\utcspsh.sig"
  Delete "$SYSDIR\UniMateP11.dll"
  
${DisableX64FSRedirection}
SetRegView 64
  DeleteRegKey HKCU "Software\Microsoft\SystemCertificates\My\PhysicalStores\UniMateStore"

 System::Call "Kernel32::Wow64EnableWow64FsRedirection(i 1)"

	ExecWait '$SYSDIR\regsvr32 /s /u "$SYSDIR\utcsp.dll"'

  Delete "$SYSDIR\utcsp.dll"
  Delete "$SYSDIR\utcspsh.dll"
  Delete "$SYSDIR\utcspsh.sig"
  Delete "$SYSDIR\UniMateP11.dll"
  SetRegView 32
  DeleteRegKey HKCU "Software\Microsoft\SystemCertificates\My\PhysicalStores\UniMateStore"

${Else}
	ExecWait '$SYSDIR\regsvr32 /s /u "$SYSDIR\utcsp.dll"'

  Delete "$SYSDIR\utcsp.dll"
  Delete "$SYSDIR\utcspsh.dll"
  Delete "$SYSDIR\utcspsh.sig"
  Delete "$SYSDIR\UniMateP11.dll"
  DeleteRegKey HKCU "Software\Microsoft\SystemCertificates\My\PhysicalStores\UniMateStore"

${EndIf}

  Delete "$SMPROGRAMS\${PRODUCT_NAME}\PKI package\${PRODUCT_NAME}.url"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\PKI package\uninst.exe"
	RMDir /r "$SMPROGRAMS\${PRODUCT_NAME}\PKI package"
  IfFileExists "$SMPROGRAMS\${PRODUCT_NAME}\PKI package" +3 +1
	IfFileExists "$SMPROGRAMS\${PRODUCT_NAME}\Console" +2 +1
	RMDIR /r  "$SMPROGRAMS\${PRODUCT_NAME}"

	SetShellVarContext all
  
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKCU "Software\Microsoft\SystemCertificates\My\PhysicalStores\UniMateStore"
  
  SetAutoClose true
SectionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) has been removed completely."
FunctionEnd
